<?php defined('PF_VERSION') OR exit('Access denied');?>
<?php

define('PLUGIN_ANNOUNCEMENT', __('Announcement', 'announcement'));

class Announcement_Plugin extends Pf_Plugin{
    public $name = PLUGIN_ANNOUNCEMENT;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the Announcement description';
    public function activate(){
    	$db = Pf::database();
    	$sql = "DROP TABLE IF EXISTS `pf_announcement`;";
    	$db->query($sql);
    
    	$sql = "CREATE TABLE `pf_announcement` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `announcement_status` tinyint(4) NOT NULL,
                `announcement_pubdate` timestamp NULL DEFAULT NULL,
                `announcement_unpubdate` timestamp NULL DEFAULT NULL,
                `announcement_type` tinyint(4) NOT NULL,
                `announcement_content` varchar(255) NOT NULL,
                `announcement_author` varchar(50) NOT NULL,
                `announcement_to` varchar(255) NOT NULL,
                PRIMARY KEY (`id`)
               ) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8
                ";
    	$db->query($sql);
    }
    
    public function deactivate(){
    	$db = Pf::database();
    	$sql = "DROP TABLE IF EXISTS `pf_announcement`;";
    	$db->query($sql);
    }    
    public function admin_init(){
        if (is_admin())
        $this->admin_menu('fa fa-bell', __('Announcement', 'announcement'),'announcement', 'pf_announcement_manager_main' );
    }
    public function public_init() {
        
        $shortcode = Pf::shortcode();
        $shortcode->add('announcement', array($this, 'announcement_shortcode'));
    }
    function announcement_shortcode($atts, $content = null, $code = '') {
        $type= array(
                1=>'danger',
                2=>'info',
                3=>'warning',
                4=>'success' 
                );
        require_once abs_plugin_path(__FILE__) . "/announcement/class/announcement-class.php";
        ob_start();
        require_once abs_plugin_path(__FILE__) . "/announcement/public/announcement-public.php";
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }
    function pf_announcement_manager_main(){
        if (is_admin()) {
            $type= array(
                1=>'Danger',
                2=>'Info',
                3=>'Warning',
                4=>'Success' 
                );
            $dateformat     = get_configuration('long_date');
            $error_empty    =   __("Please enter announcement content!",'announcement');
            $error_tolong   =   __("Announcement can not more than 255 characters!",'announcement');
            $form_pubdate   =   array('name' => 'publish_date', 'class' => 'form-control', 'tabindex' => 4);
            $form_unpubdate =   array('name' => 'unpublish_date', 'class' => 'form-control', 'tabindex' => 4);
            $form_touser    =   array('name' => 'toUser', 'class' => 'form-control', 'id'=> 'tag');
            $this->css('admin/plugins/announcement/asset/bootstrap-tagsinput.css');
            $this->js('admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js');
            $this->css('admin/plugins/announcement/asset/magicsuggest-1.3.1-min.css');
            $this->js('admin/plugins/announcement/asset/magicsuggest-1.3.1-min.js');
            $this->css('admin/themes/default/assets/bootstrap-modal/css/animate.min.css');
            $this->js('admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
            $this->js('admin/plugins/announcement/asset/announcement.js');
            $this->js('admin/plugins/announcement/asset/moment.js');
            $this->js('admin/plugins/announcement/asset/bootstrap-datetimepicker.js');
            $this->css('admin/plugins/announcement/asset/bootstrap-datetimepicker.css');
            $this->css('admin/plugins/announcement/asset/anouncement.css');
            $actions = array('create', 'edit', 'list');
            $action = (isset($_GET['action']) && in_array($_GET['action'], $actions) == true) ? $_GET['action'] : 'list';
            require abs_plugin_path(__FILE__) . '/announcement/class/announcement-class.php';
            $announcement   =   new Pf_Announcement;
            require abs_plugin_path(__FILE__) . '/announcement/actions/'.$action.'.php';
    } else
            echo __('Access Denied!','annoucement')."dssdsd";    
    }
}